/*****************************************************************************/

/*
 *
 *   Copyright (c) 2002, Smart Link Ltd.
 *   All rights reserved.
 *
 *   Redistribution and use in source and binary forms, with or without
 *   modification, are permitted provided that the following conditions
 *   are met:
 *
 *       1. Redistributions of source code must retain the above copyright
 *          notice, this list of conditions and the following disclaimer.
 *       2. Redistributions in binary form must reproduce the above
 *          copyright notice, this list of conditions and the following
 *          disclaimer in the documentation and/or other materials provided
 *          with the distribution.
 *       3. Neither the name of the Smart Link Ltd. nor the names of its
 *          contributors may be used to endorse or promote products derived
 *          from this software without specific prior written permission.
 *
 *   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *   A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *   OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *   SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *   LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *   DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *   THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *   (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *   OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/*
 *
 *	linux_compat.h  --  old linux kernel versions compatability.
 *
 *	Author: Sasha K (sashak@smlink.com)
 *
 *
 */

/*****************************************************************************/

#ifndef __LINUX_COMPAT_H__
#define __LINUX_COMPAT_H__

#include <linux/version.h>

/* ----------- different kernel versions compatability support ----------- */

/* kernel < 2.2.18 */
#if LINUX_VERSION_CODE < KERNEL_VERSION(2,2,18)

typedef struct wait_queue *wait_queue_head_t;
#define init_waitqueue_head(q) init_waitqueue(q)
#define DECLARE_MUTEX(sem) struct semaphore sem = MUTEX;
#define DECLARE_WAITQUEUE(wqueue,task) struct wait_queue wqueue = { task, NULL };
#define set_current_state(newstate) {current->state = newstate;}
#define schedule_task(task) queue_task(task, &tq_scheduler)
#define del_timer_sync(timer) del_timer(timer)

#ifdef MODULE
#define module_exit(x) void cleanup_module(void) { x(); }
#define module_init(x) int init_module(void) { return x(); }
#else
#define module_exit(x) /* nothing */
#define module_init(x) /* nothing */
#endif /* MODULE */

#endif  /* KERNEL_VERSION < 2.2.18 */


/* kernel < 2.4.3 */
#if LINUX_VERSION_CODE < KERNEL_VERSION(2,4,3)
#ifndef INIT_TQUEUE
#define INIT_TQUEUE(_tq, _routine, _data)                       \
        do {                                                    \
                INIT_LIST_HEAD(&(_tq)->list);                   \
                (_tq)->sync = 0;                                \
                (_tq)->routine = _routine;                      \
                (_tq)->data = _data;                            \
        } while (0)

#endif
#endif /* KERNEL_VERSION < 2.4.3 */

/* kernel < 2.4.17 */
#if LINUX_VERSION_CODE < KERNEL_VERSION(2,4,17)
#ifndef MODULE_LICENSE
#define MODULE_LICENSE(license)
#endif
#endif /* KERNEL_VERSION < 2.4.17 */

/* kernel >= 2.4.20 */
#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,4,20)
#define iso_packet_descriptor_t struct iso_packet_descriptor
#endif /* KERNEL_VERSION >= 2.4.20 */

#endif /* __LINUX_COMPAT_H__ */

