/*****************************************************************************/

/*
 *
 *   Copyright (c) 2002, Smart Link Ltd.
 *   All rights reserved.
 *
 *   Redistribution and use in source and binary forms, with or without
 *   modification, are permitted provided that the following conditions
 *   are met:
 *
 *       1. Redistributions of source code must retain the above copyright
 *          notice, this list of conditions and the following disclaimer.
 *       2. Redistributions in binary form must reproduce the above
 *          copyright notice, this list of conditions and the following
 *          disclaimer in the documentation and/or other materials provided
 *          with the distribution.
 *       3. Neither the name of the Smart Link Ltd. nor the names of its
 *          contributors may be used to endorse or promote products derived
 *          from this software without specific prior written permission.
 *
 *   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *   A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *   OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *   SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *   LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *   DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *   THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *   (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *   OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/*
 *
 *	sysdep_pci.c  --  pci driver sysdep routines.
 *
 *	Author: Seva (seva@smlink.com)
 *
 *
 */

/*****************************************************************************/


#include <linux/version.h>
#include <linux/module.h>

#include <linux/kernel.h>
#include <linux/mm.h>
#include <linux/slab.h>
#include <linux/delay.h>
#include <linux/interrupt.h>
#include <linux/pci.h>
#include <asm/io.h>

#include <linux_compat.h>

/* dmesg print */
void sysdep_dmesg_print(const char *s)
{
	printk("%s\n",s);
}

/* page allocations */
unsigned long sysdep_get_free_pages(unsigned long order)
{
	return __get_free_pages(GFP_KERNEL, order);
}

void sysdep_free_pages(unsigned long addr, unsigned long order)
{
	free_pages(addr, order);
}

unsigned long sysdep_virt_to_phys(volatile void * address)
{
	return virt_to_phys (address);
}

void *sysdep_create_bh(void (*handler)(void*), void * data)
{
	struct tq_struct *tq =(struct tq_struct *)kmalloc(sizeof(struct tq_struct),GFP_KERNEL);
	if (tq != NULL) {
		INIT_TQUEUE(tq,handler,data);
	}
	return tq;
}

void sysdep_request_bh(void * queue_struct)
{
	if (queue_struct != NULL) {
		queue_task(queue_struct, &tq_immediate);
		mark_bh(IMMEDIATE_BH);
	}
}

void sysdep_delete_bh(void * queue_struct)
{
	if (queue_struct != NULL) kfree(queue_struct);
}

/* delay */
void sysdep_udelay(unsigned long usecs)
{
	udelay(usecs);
}

void sysdep_mdelay(unsigned long msecs)
{
	mdelay(msecs);
}

/* from linux/pci.h */
int sysdep_pci_read_config_byte (void *dev, unsigned char where, unsigned char *val)
{	
        return pci_read_config_byte (dev, where, val);
}

int sysdep_pci_read_config_word (void *dev, unsigned char where, unsigned short *val)
{
        return pci_read_config_word (dev, where, val);
}

int sysdep_pci_read_config_dword (void *dev, unsigned char where, unsigned int *val)
{
        return pci_read_config_dword (dev, where, val);
}

int sysdep_pci_write_config_byte (void *dev, unsigned char where, unsigned char val)
{
        return pci_write_config_byte (dev, where, val);
}

int sysdep_pci_write_config_word (void *dev, unsigned char where, unsigned short val)
{
        return pci_write_config_word (dev, where, val);
}

int sysdep_pci_write_config_dword (void *dev, unsigned char where, unsigned int val)
{
	return pci_write_config_dword (dev, where, val);
}


/* io */
unsigned char sysdep_inb(unsigned short port)
{
	return inb(port);
}
void sysdep_outb(unsigned char data,unsigned short port)
{
	outb(data,port);
}
unsigned short sysdep_inw(unsigned short port) 
{
	return inw(port);
}

void sysdep_outw(unsigned short data,unsigned short port)
{
	outw(data,port);
}
unsigned long sysdep_inl(unsigned short port) 
{
	return inl(port);
}
void sysdep_outl(unsigned long data,unsigned short port)
{
	outl(data,port);
}

/* cli/sti handling */
void sysdep_save_flags   (unsigned long *flags) {save_flags(*flags); }
void sysdep_restore_flags(unsigned long *flags) {restore_flags(*flags);}
void sysdep_cli(void) {cli();}

