/*****************************************************************************/

/*
 *
 *   Copyright (c) 2002, Smart Link Ltd.
 *   All rights reserved.
 *
 *   Redistribution and use in source and binary forms, with or without
 *   modification, are permitted provided that the following conditions
 *   are met:
 *
 *       1. Redistributions of source code must retain the above copyright
 *          notice, this list of conditions and the following disclaimer.
 *       2. Redistributions in binary form must reproduce the above
 *          copyright notice, this list of conditions and the following
 *          disclaimer in the documentation and/or other materials provided
 *          with the distribution.
 *       3. Neither the name of the Smart Link Ltd. nor the names of its
 *          contributors may be used to endorse or promote products derived
 *          from this software without specific prior written permission.
 *
 *   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *   A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *   OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *   SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *   LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *   DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *   THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *   (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *   OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/*
 *
 *	mdm_init.c  --  modem initializations.
 *
 *	Author: Sasha K (sashak@smlink.com)
 *
 *
 */

/*****************************************************************************/


#include <linux/module.h>
#include <linux/version.h>
#include <linux/init.h>
#include <linux/kernel.h>

#include <linux_compat.h>


/* module parameters */

static int __initdata debug = 0;
#ifdef DEBUG
MODULE_PARM(debug, "i");
MODULE_PARM_DESC(debug, "Debug level: 0-4, default=0");
#endif

static int __initdata country_code = -1; /* 0xb5; */ /* USA */
MODULE_PARM(country_code, "i");
MODULE_PARM_DESC(country_code, "Country code (T.35): 0-255, default=181 (USA)");

static char __initdata *country= "USA";
MODULE_PARM(country, "s");
MODULE_PARM_DESC(country, "Country name, default=`USA'");

#define COUNTRY_FILE "/etc/country.dat"
static char __initdata *country_file= COUNTRY_FILE;
MODULE_PARM(country_file, "s");
MODULE_PARM_DESC(country_file, "Country dat file, default " COUNTRY_FILE );

MODULE_AUTHOR("Smart Link Ltd.");
MODULE_DESCRIPTION("Smart Link Soft Modem");
MODULE_LICENSE("Smart Link Ltd.");

/* modem initialization prototypes */
extern int modem_init(int debug,char *country_file,int country_code,char *country);
extern void modem_exit(void);

/* ------------------------------------------------------------ */

static __init int mdm_init (void)
{
	extern const char *modem_vendor;
	extern const char *modem_version;
	extern const char *modem_version_date;
	printk(KERN_INFO "slmdm: version %s %s (%s).\n",
	       modem_version,modem_version_date,modem_vendor);
	return modem_init(debug,country_file, country_code, country);
}

static __exit void mdm_exit (void)
{
	modem_exit();
}

module_init(mdm_init);
module_exit(mdm_exit);

