/*****************************************************************************/

/*
 *
 *   Copyright (c) 2002, Smart Link Ltd.
 *   All rights reserved.
 *
 *   Redistribution and use in source and binary forms, with or without
 *   modification, are permitted provided that the following conditions
 *   are met:
 *
 *       1. Redistributions of source code must retain the above copyright
 *          notice, this list of conditions and the following disclaimer.
 *       2. Redistributions in binary form must reproduce the above
 *          copyright notice, this list of conditions and the following
 *          disclaimer in the documentation and/or other materials provided
 *          with the distribution.
 *       3. Neither the name of the Smart Link Ltd. nor the names of its
 *          contributors may be used to endorse or promote products derived
 *          from this software without specific prior written permission.
 *
 *   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *   A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *   OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *   SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *   LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *   DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *   THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *   (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *   OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/*
 *
 *	modem_driver.h  --  modem device driver interface.
 *
 *	Author: Sasha K (sashak@smlink.com)
 *
 */

/*****************************************************************************/

#ifndef __modem_driver_h__
#define __modem_driver_h__


/* hook states */
#define MODEM_HOOK_ON        0
#define MODEM_HOOK_OFF       1
#define MODEM_HOOK_SNOOPING  2

/* modem device ctrl interface */
#define MDMCTL_CAPABILITIES  0x01
#define MDMCTL_HOOKSTATE     0x02
#define MDMCTL_IODELAY       0x03
#define MDMCTL_SPEED         0x04
#define MDMCTL_GETFMTS       0x05
#define MDMCTL_SETFMT        0x06
#define MDMCTL_SETFRAGMENT   0x07
#define MDMCTL_MAPIOBUFS     0x10
#define MDMCTL_UNMAPIOBUFS   0x11

/* sample formats + extensions */
#define MFMT_SIZE_MASK   0x000f
#define MFMT_SIZE_8      0x0000
#define MFMT_SIZE_16     0x0001
#define MFMT_SIGN_MASK   0x00f0
#define MFMT_SIGNED      0x0010
#define MFMT_UNSIGNED    0x0000
#define MFMT_ORDER_MASK  0x0f00
#define MFMT_ORDER_LE    0x0100
#define MFMT_ORDER_BE    0x0000

#define MFMT_QUERY       0x0

#define MFMT_S8          MFMT_SIZE_8|MFMT_SIGNED
#define MFMT_U8          MFMT_SIZE_8|MFMT_UNSIGNED
#define MFMT_S16_LE      MFMT_SIZE_16|MFMT_SIGNED|MFMT_ORDER_LE
#define MFMT_S16_BE      MFMT_SIZE_16|MFMT_SIGNED|MFMT_ORDER_BE
#define MFMT_U16_LE      MFMT_SIZE_16|MFMT_UNSIGNED|MFMT_ORDER_LE
#define MFMT_U16_BE      MFMT_SIZE_16|MFMT_UNSIGNED|MFMT_ORDER_BE

#define MFMT_IS_16BIT(x)   ((x)&MFMT_SIZE_16)
#define MFMT_IS_LE(x)      ((x)&MFMT_ORDER_LE)
#define MFMT_BYTESSHIFT(x) ((x)&MFMT_SIZE_MASK)
#define MFMT_BYTES(x)      (1<<MFMT_BYTESSHFIT(x))


/* mem buffer description */
typedef struct buffmem_desc {
	unsigned  in_size;
	void     *in_buffer;
	unsigned  out_size;
	void     *out_buffer;
} buffmem_desc ;


/* modem driver structure */
struct modem_driver {
	const char *name;
	int start_minor;     /* start minor number */
	int num;             /* number of devices */
	/* modem dev driver interface */
	void *(*open )(void *modem, int minor);
	int (*close)(void *dev);
	int (*start)(void *dev);
	int (*stop )(void *dev);
	int (*read )(void *dev, char *buf, int count);
	int (*write)(void *dev, char *buf, int count);
	int (*ioctl)(void *dev, unsigned cmd, unsigned long arg);
};

/* modem procedures */
extern int modem_process(void *modem);
extern int modem_ring(void *modem);
extern int modem_error(void *modem);
extern int modem_release(void *modem);

/* register/unregister driver */
extern int register_modem_driver(struct modem_driver *);
extern int unregister_modem_driver(struct modem_driver *);

extern struct modem_driver *find_modem_driver(int minor);

#endif /* __modem_driver_h__ */
